/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.net;

import com.ibm.hwmca.fw.net.LocalSocketInputStream;
import com.ibm.hwmca.fw.net.LocalSocketOutputStream;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

class LocalSocketImpl {
    private static final String TRACE_MASKF = "XLSKJSIF";
    int fd = -1;
    int timeout;
    String boundPath;
    boolean shutdownForReading;
    boolean shutdownForWriting;
    LocalSocketInputStream inputStream;
    LocalSocketOutputStream outputStream;
    long nativeData;

    public LocalSocketImpl() throws IOException {
        this.nativeObjectInit();
        this.fd = this.createSocket();
        Trace.trace(TRACE_MASKF, "Allocating local socket for fd " + this.fd);
    }

    public LocalSocketImpl(int fd) {
        Trace.trace(TRACE_MASKF, "Creating local socket for fd " + fd);
        this.nativeObjectInit();
        this.fd = fd;
    }

    private static native void initializeNative();

    private native void nativeObjectInit();

    native int createSocket() throws IOException;

    static native int[] createSocketPair() throws IOException;

    public synchronized native String getPeerAddress() throws IOException;

    public synchronized native String getLocalAddress() throws IOException;

    public void bind(String localPath) throws IOException {
        this.nativeBind(localPath);
        this.boundPath = localPath;
        new File(localPath).deleteOnExit();
    }

    synchronized native void nativeBind(String var1) throws IOException;

    public void listen() throws IOException {
        this.listen(50);
    }

    public synchronized native void listen(int var1) throws IOException;

    public native void connect(String var1) throws IOException;

    public LocalSocketImpl accept() throws IOException {
        return new LocalSocketImpl(this.nativeAccept());
    }

    native int nativeAccept() throws IOException;

    public synchronized InputStream getInputStream() throws IOException {
        if (this.fd == -1) {
            throw new IOException("Socket is closed");
        }
        if (this.shutdownForReading) {
            throw new IOException("Socket is shutdown for reading");
        }
        if (this.inputStream == null) {
            this.inputStream = new LocalSocketInputStream(this);
        }
        return this.inputStream;
    }

    public synchronized native int availableForReading() throws IOException;

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.fd == -1) {
            throw new IOException("Socket is closed");
        }
        if (this.shutdownForWriting) {
            throw new IOException("Socket is shutdown for writing");
        }
        if (this.outputStream == null) {
            this.outputStream = new LocalSocketOutputStream(this);
        }
        return this.outputStream;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public void setSoLinger(boolean on) throws SocketException {
        this.setSoLinger(on, Integer.MAX_VALUE);
    }

    public synchronized native void setSoLinger(boolean var1, int var2) throws SocketException;

    public synchronized native int getSoLinger() throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int fdCopy;
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fd == -1) {
                return;
            }
            fdCopy = this.fd;
            this.fd = -1;
        }
        this.nativeClose(fdCopy);
        if (this.boundPath != null && this.boundPath.length() > 0) {
            new File(this.boundPath).delete();
        }
    }

    native void nativeClose(int var1) throws IOException;

    public synchronized void shutdownInput() throws IOException {
        this.nativeShutdownInput();
        this.shutdownForReading = true;
    }

    native void nativeShutdownInput() throws IOException;

    public synchronized void shutdownOutput() throws IOException {
        this.nativeShutdownOutput();
        this.shutdownForWriting = true;
    }

    native void nativeShutdownOutput() throws IOException;

    public native int read() throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public native void write(int var1) throws IOException;

    public native void write(byte[] var1, int var2, int var3) throws IOException;

    public synchronized int getFd() {
        if (this.fd == -1) {
            throw new IllegalStateException("Socket is closed");
        }
        return this.fd;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static LocalSocketImpl[] getSocketPair() throws IOException {
        int[] fds = LocalSocketImpl.createSocketPair();
        LocalSocketImpl[] impls = new LocalSocketImpl[]{new LocalSocketImpl(fds[0]), new LocalSocketImpl(fds[1])};
        return impls;
    }

    static {
        try {
            System.loadLibrary("jniLocalSockets");
            LocalSocketImpl.initializeNative();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Unable to load native method library \"jniLocalSockets\":" + e);
        }
    }
}

